﻿using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL
{
    /// <summary>
    /// Klasa BLowa tworząca raporty dla danych obiektów (Student, Instruktor, ...)
    /// Wykorzystuje PDFCreater'a
    /// </summary>
    public static partial class PDFReport
    {
        public class Config
        {
            /// <summary>
            /// Root do wszystkich danych potrzebych do generowania raportów
            /// oraz do przetrzymywanych tymczasowych anych
            /// </summary>
            public const string REPORT_ROOT = "/report/";

            
            /// <summary>
            /// Nazwa pliku z tłem do certyfikatu drukowanego dla studentów
            /// </summary>
            public const string CERT_BACKGROUNG_IMAGE = "bg/cert.jpg";

            /// <summary>
            /// Ścieżka do przechowywania wygenerowanych raportów
            /// </summary>
            public const string TEMPORARY_REPORTS = "certyfikat/";

            /// <summary>
            /// Ścieżka do czcionek raportowych
            /// </summary>
            public const string TEMPORARY_FONT = "font/";

            /// <summary>
            /// Format pliku raportu certyfikatu dla studenta
            /// parametr 0 - student id
            /// </summary>
            public const string STUDENT_CERT_FORMAT = "certyfikat_{0}.pdf";

            /// <summary>
            /// Nazwa certyfikatu z zakresu przedsiębiorczości.
            /// Zakładamy że tylko jeden taki certyfikat może być dla studenta wydrukowany.
            /// Każdorazowe przedrukowanie musi być poprzedzone jego usunięciem
            /// </summary>
            public const string CERTYFIKAT_NAME = "Certyfikat z zakresu przedsiębiorczości";
        }

        /// <summary>
        /// Metoda usuwa certyfikaty dla wszystkich uczniów w klasie
        /// </summary>
        /// <param name="Class"></param>
        /// <param name="Environment"></param>
        public static void RemoveClassCert(PI.ZB.N1200.ELearning.BL.BO.Class Class, Gemini.Core.BL.Interface.IEnvironment Environment)
        {
            PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = new ZSBELearning(Environment);
            List<BO.Student> _listStudent = _blZSBELearning.Student.Restore(Class);
            foreach (BO.Student _loopStudent in _listStudent)
            {
                RemoveStudentCert(_loopStudent, Environment);
            }
        }

        /// <summary>
        /// metoda usuwająca certyfikat strudenta jeżeli był już raz drukowany
        /// </summary>
        /// <param name="Student"></param>
        /// <param name="Environment"></param>
        public static void RemoveStudentCert(PI.ZB.N1200.ELearning.BL.BO.Student Student, Gemini.Core.BL.Interface.IEnvironment Environment)
        {
            PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = new ZSBELearning(Environment);

            // szukamy wpisu w bazie
            BO.StudentDoc _existingStudentDoc = _blZSBELearning.StudentDoc.Restore(Student, Config.CERTYFIKAT_NAME);

            //sprawdzamy czy jest juz w bazie nasz certyfikat i jezeli tak, to sprawdzamy czy trzeba go przegenerowac
            // tzn., czy jest na dysku plik fizycznie dla niego
            if (_existingStudentDoc != null)
            {
                if (System.IO.File.Exists(GetRootedPath(_existingStudentDoc.Path, Environment)))
                {
                    System.IO.File.Delete(GetRootedPath(_existingStudentDoc.Path, Environment));
                }
                _blZSBELearning.StudentDoc.Remove(_existingStudentDoc);
            }
        }

        /// <summary>
        /// Metoda generuje certyfikaty dla wszystkich uczniów w danej klasie
        /// </summary>
        /// <param name="Student"></param>
        /// <param name="Environment"></param>
        /// <returns></returns>
        public static void GenerateClassCert(PI.ZB.N1200.ELearning.BL.BO.Class Class, Gemini.Core.BL.Interface.IEnvironment Environment)
        {
            PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = new ZSBELearning(Environment);
            List<BO.Student> _listStudent = _blZSBELearning.Student.Restore(Class);
            foreach (BO.Student _loopStudent in _listStudent)
            {
                GenerateStudentCert(_loopStudent, Environment);
            }
        }

        /// <summary>
        /// Generuje certyfikat dla studenta
        /// </summary>
        /// <param name="Student"></param>
        /// <returns></returns>
        public static string GenerateStudentCert(PI.ZB.N1200.ELearning.BL.BO.Student Student, Gemini.Core.BL.Interface.IEnvironment Environment)
        {
            if (Student == null)
            {
                return null;
            }

            PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = new ZSBELearning(Environment);
            BL.ZSBELearning.ContextParam _validContext = _blZSBELearning.Utility.GetValidContext(Student);
            if (_validContext == null)
            {
                return null;
            }

            // szukamy wpisu w bazie
            BO.StudentDoc _existingStudentDoc = _blZSBELearning.StudentDoc.Restore(Student, Config.CERTYFIKAT_NAME);

            //sprawdzamy czy jest juz w bazie nasz certyfikat i jezeli tak, to sprawdzamy czy trzeba go przegenerowac
            // tzn., czy jest na dysku plik fizycznie dla niego
            if (_existingStudentDoc != null)
            {
                //if (System.IO.File.Exists(GetRootedPath(_existingStudentDoc.Path, Environment)))
                //{
                //    return _existingStudentDoc.Path;
                //}
                _blZSBELearning.StudentDoc.Remove(_existingStudentDoc);
            }

            // ustawiamy ścieżkę do pliku
            string _tempFileName = String.Format("{0}{1}{2}", Config.REPORT_ROOT, Config.TEMPORARY_REPORTS, String.Format(Config.STUDENT_CERT_FORMAT, Student.ID));
            if (System.IO.File.Exists(GetRootedPath(_tempFileName, Environment)))
            {
                // jeżeli jest to musimy go usunąć bo nie ma go w bazie danych, więc tak jakby go nie było
                System.IO.File.Delete(GetRootedPath(_tempFileName, Environment));
            }

            // zaczynamy zabawe z generowaniem nowego certyfikatu
            BO.EvaluationSheet _evaluationSheet = _blZSBELearning.EvaluationSheet.Restore(Student.CompetenceEvaluationSheetID);
            DateTime _endKnowledgeTestEvaluationDate = DateTime.Now;
            string _endKnowledgeTestEvaluation = "BRAK OCENY";
            BO.EvaluationSheet _evaluationSheetCompetence = _blZSBELearning.EvaluationSheet.Restore(Student.AdvancedTestEndEvaluationSheetID);
            if (_evaluationSheetCompetence != null)
            {
                _endKnowledgeTestEvaluation = _evaluationSheetCompetence.Name;
                //_endKnowledgeTestEvaluationDate = // uzupelnic
            }

            // generowanie raportu do pliku
            PDFCreator _creator = new PDFCreator(GetRootedPath(String.Format("{0}{1}", Config.REPORT_ROOT, Config.TEMPORARY_FONT), Environment));
            _creator.CreateCert("Certyfikat z zakresu przedsiębiorczości", "Certyfikat", "eduKariera", GetRootedPath(_tempFileName, Environment), GetRootedPath(string.Format("{0}{1}", Config.REPORT_ROOT, Config.CERT_BACKGROUNG_IMAGE), Environment), String.Format("{0} {1}", Student.Forename, Student.Surename), _evaluationSheet != null ? _evaluationSheet.Name : "BRAK OCENY", _endKnowledgeTestEvaluation, _endKnowledgeTestEvaluationDate);

            // zapisanie ściezki do certyfikatu w bazie dla danego studenta
            BO.StudentDoc _studentDocNew = _blZSBELearning.StudentDoc.New();
            _studentDocNew.Flags = 0;
            _studentDocNew.Name = Config.CERTYFIKAT_NAME;
            _studentDocNew.Path = _tempFileName;
            _studentDocNew.StudentID = Student.ID;
            _blZSBELearning.StudentDoc.Save(_studentDocNew);

            // koniec
            return _tempFileName;
        }

        private static string GetRootedPath(string Path, Gemini.Core.BL.Interface.IEnvironment Environment)
        {
#if DEBUG
            return String.Format("{0}ResorcesProjects/{1}{2}", Environment.ApplicationDirectory, Environment.ProjectName, Path);
#else
            return String.Format("{0}{1}{2}", Environment.ApplicationDirectory, Environment.ProjectName, Path);
#endif
        }
    }
}
